﻿using System;
using System.Windows.Forms;
using RDR2;
using RDR2.UI;
using RDR2.Native;
using RDR2.Math;

namespace HCL_Superpower_03
{
    public class Main : Script
    {
        Player player = Game.Player;
        Ped playerPed = Game.Player.Character;
        bool EXPCasting = false;
        bool EXPON = false;
        int EXPNumber = 1;
        int MaxEXP = 100;

        public Main()
        {
            KeyDown += OnKeyDown;
            KeyUp += OnKeyUp;
            Tick += OnTick;
            Interval = 1;
        }

        private void OnTick(object sender, EventArgs e)
        {
            Ped playerPed = Game.Player.Character;   
            if (EXPON)
            {
                    Vector3 Shockspace = new Vector3(RotToDir(NC_Get_Cam_Rotation()).X * 3f, RotToDir(NC_Get_Cam_Rotation()).Y * 3f, RotToDir(NC_Get_Cam_Rotation()).Z * 3f);
                    if (EXPNumber < MaxEXP || EXPNumber == MaxEXP)
                    {
                             Function.Call(Hash.ADD_EXPLOSION, (playerPed.Position.X + EXPNumber*Shockspace.X), (playerPed.Position.Y + EXPNumber*Shockspace.Y), (playerPed.Position.Z + EXPNumber*Shockspace.Z), 2, 2.0f, true, false, 0);
                             Wait(100);
                             EXPNumber = EXPNumber + 1;
                    }
                    else
                    {
                             Function.Call(Hash.ADD_EXPLOSION, (playerPed.Position.X + MaxEXP*Shockspace.X), (playerPed.Position.Y + MaxEXP*Shockspace.Y), (playerPed.Position.Z + MaxEXP*Shockspace.Z), 2, 2.0f, true, false, 0);
                             Wait(100);
                    }
            }
        } 

        private void OnKeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.F3 && !e.Shift)
            {
                   if (!EXPON)
                   {
                        Function.Call(Hash.SET_PLAYER_INVINCIBLE, player, true);  
                        EXPON = true;
                   }
            }
        }

        private void OnKeyUp(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.F3 && !e.Shift)
            {
                 EXPON = false;
                 EXPNumber = 1;
                 Function.Call(Hash.SET_PLAYER_INVINCIBLE, player, false);  
            }
            if (e.KeyCode == Keys.F4 && !e.Shift)
            {
                    if (!EXPCasting)
                    {
                              Function.Call(Hash.SET_PLAYER_INVINCIBLE, player, true);  
                              Function.Call(Hash.ADD_EXPLOSION, (playerPed.Position.X), (playerPed.Position.Y), (playerPed.Position.Z), 3, 2.0f, true, false, 0);
                              EXPCasting = true;
                              Wait(200);
                              Function.Call(Hash.SET_PLAYER_INVINCIBLE, player, false);  
                              EXPCasting = false;
                    }
            }
        }

        public Vector3 RotToDir(Vector3 Rot)
        {
            try
            {
                float z = Rot.Z;
                float retz = z * 0.0174532924F;
                float x = Rot.X;
                float retx = x * 0.0174532924F;
                float absx = (float)System.Math.Abs(System.Math.Cos(retx));
                return new Vector3((float)-System.Math.Sin(retz) * absx, (float)System.Math.Cos(retz) * absx, (float)System.Math.Sin(retx));
            }
            catch
            {
                return new Vector3(0, 0, 0);
            }
        }

        public Vector3 NC_Get_Cam_Position()
        {
            try
            {
                return Function.Call<Vector3>(Hash.GET_GAMEPLAY_CAM_COORD);
            }
            catch
            {

            }
            return new Vector3(0, 0, 0);
        }

        public Vector3 NC_Get_Cam_Rotation()
        {
            try
            {
                return Function.Call<Vector3>(Hash.GET_GAMEPLAY_CAM_ROT, 0);
            }
            catch
            {

            }
            return new Vector3(0, 0, 0);
        } 
    }
}
